<?php
include('../../includes/checkSession.php');
include('../../includes/con2pma3.php'); // DB link already available upstream in your pages

$project_id = isset($_POST['projname']) ? (int)$_POST['projname'] : null;
$pdriname   = isset($_POST['pdriname']) ? trim($_POST['pdriname']) : null;
$pdrirev    = isset($_POST['pdrirev']) ? trim($_POST['pdrirev']) : null;
$preparedby = isset($uid) ? (int)$uid : (isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : null);
$date       = date('Y-m-d');
$companyID  = isset($_SESSION['id']) ? (int)$_SESSION['id'] : null;

// derive client_id from selected project
$client_id = null;
if ($project_id) {
    if ($stmtProj = $mysqli->prepare("SELECT projVendor FROM projects WHERE projectSerial = ?")) {
        $stmtProj->bind_param("i", $project_id);
        if ($stmtProj->execute()) {
            $resProj = $stmtProj->get_result();
            if ($resProj && ($rowProj = $resProj->fetch_assoc())) {
                $client_id = (int)$rowProj['projVendor'];
            }
        }
        $stmtProj->close();
    }
}

// delete (soft)
if (isset($_REQUEST['del'])) {
    $pdriid = (int)$_REQUEST['del'];
    if ($stmt = $mysqli->prepare("UPDATE pdri SET pdri_status = 2 WHERE pdri_id = ?")) {
        $stmt->bind_param("i", $pdriid);
        if (!$stmt->execute()) { die("Failed to Update : " . $mysqli->error); }
        $stmt->close();
    } else { die("Failed to prepare : " . $mysqli->error); }
    header("location: 03-03Scope-01PDRI01.php?msg=DELETED"); exit;
}

// activate
if (isset($_REQUEST['Active'])) {
    $pdriid = (int)$_REQUEST['Active'];
    if ($stmt = $mysqli->prepare("UPDATE pdri SET pdri_status = 1 WHERE pdri_id = ?")) {
        $stmt->bind_param("i", $pdriid);
        if (!$stmt->execute()) { die("Failed to Update : " . $mysqli->error); }
        $stmt->close();
    } else { die("Failed to prepare : " . $mysqli->error); }
    header("location: 03-03Scope-01PDRI01.php?msg=ACTIVE"); exit;
}

// inactivate
if (isset($_REQUEST['InActive'])) {
    $pdriid = (int)$_REQUEST['InActive'];
    if ($stmt = $mysqli->prepare("UPDATE pdri SET pdri_status = 0 WHERE pdri_id = ?")) {
        $stmt->bind_param("i", $pdriid);
        if (!$stmt->execute()) { die("Failed to Update : " . $mysqli->error); }
        $stmt->close();
    } else { die("Failed to prepare : " . $mysqli->error); }
    header("location: 03-03Scope-01PDRI01.php?msg=HIDDEN"); exit;
}

// update
if (isset($_REQUEST['Edit'])) {
    $pdriID = (int)$_REQUEST['Edit'];
    $sql = "UPDATE pdri SET `project_id`=?, `client_id`=?, `pdri_name`=?, `pdri_PreparedBy`=?, `creationDate`=?, `companyID`=?, pdri_rev=? WHERE `pdri_id`=?";
    if ($stmt = $mysqli->prepare($sql)) {
        $stmt->bind_param("iisssisi", $project_id, $client_id, $pdriname, $preparedby, $date, $companyID, $pdrirev, $pdriID);
        if (!$stmt->execute()) { die("Failed to Update : " . $mysqli->error); }
        $stmt->close();
    } else { die("Failed to prepare : " . $mysqli->error); }
    header("location: 03-03Scope-01PDRI01.php?msg=UPDATED"); exit;
}

// insert
$sql = "INSERT INTO pdri (`project_id`,`client_id`,`pdri_name`,`pdri_PreparedBy`,`creationDate`,`companyID`, pdri_rev, `pdri_status`)
        VALUES (?,?,?,?,?,?,?,1)";
if ($stmt = $mysqli->prepare($sql)) {
    $stmt->bind_param("iisssis", $project_id, $client_id, $pdriname, $preparedby, $date, $companyID, $pdrirev);
    if (!$stmt->execute()) { die("Failed to Add : " . $mysqli->error); }
    $stmt->close();
} else { die("Failed to prepare : " . $mysqli->error); }
header("location: 03-03Scope-01PDRI01.php?msg=SAVED"); exit;
?>